/*
 * Decompiled with CFR 0.152.
 */
package de.toxicfox.toxicutils.http.server;

import de.toxicfox.toxicutils.Logger;
import de.toxicfox.toxicutils.http.server.WebserverConfig;
import io.javalin.Javalin;
import io.javalin.config.JavalinConfig;
import io.javalin.http.staticfiles.Location;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import net.shadew.json.Json;
import net.shadew.json.JsonNode;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class JavalinBuilder {
    private ArrayList<JavalinConfigurator> configurators = new ArrayList();
    private ArrayList<JavalinMiddleware> middlewares = new ArrayList();

    public JavalinBuilder(WebserverConfig config) {
        this.configurators.add(javalinConfig -> {
            if (config.isSSL()) {
                Logger.log("Configuring SSL usinf %s", config.getKeystoreFile());
                javalinConfig.jetty.addConnector((server, httpConfiguration) -> {
                    ServerConnector sslConnector = new ServerConnector(server, JavalinBuilder.getSslContextFactory(config));
                    sslConnector.setPort(config.getPort());
                    return sslConnector;
                });
            } else {
                javalinConfig.jetty.addConnector((server, httpConfiguration) -> {
                    ServerConnector connector = new ServerConnector(server);
                    connector.setPort(config.getPort());
                    return connector;
                });
            }
        });
    }

    public static JavalinBuilder create(WebserverConfig config) {
        return new JavalinBuilder(config);
    }

    public JavalinBuilder serveStatic(String hosted, File path) {
        this.configurators.add(javalinConfig -> {
            if (path.exists()) {
                javalinConfig.staticFiles.add(staticFileConfig -> {
                    staticFileConfig.hostedPath = hosted;
                    staticFileConfig.directory = path.getAbsolutePath();
                    staticFileConfig.location = Location.EXTERNAL;
                });
                Logger.log("Static host %s: %s", hosted, path.getAbsolutePath());
            } else {
                Logger.log("[WARNING] %s path not found!", path.getAbsolutePath());
            }
        });
        return this;
    }

    public JavalinBuilder serveExceptionJson() {
        this.middlewares.add(app -> app.exception(Exception.class, (exception, context) -> {
            Logger.exception(exception);
            context.status(500);
            context.header("Content-Type", "application/json");
            JsonNode error = JsonNode.object().set("status", "error").set("message", exception.getMessage());
            context.result(Json.json().serialize(error));
        }));
        return this;
    }

    public JavalinBuilder serveNotFound(File notFound) {
        this.middlewares.add(app -> app.error(404, context -> {
            context.header("Content-Type", "text/html");
            context.result(Files.newInputStream(notFound.toPath(), new OpenOption[0]));
        }));
        return this;
    }

    public JavalinBuilder corsAll() {
        this.middlewares.add(app -> app.before(context -> context.header("Access-Control-Allow-Origin", "*")));
        return this;
    }

    public Javalin build() {
        Javalin app = Javalin.create((T javalinConfig) -> {
            for (JavalinConfigurator configurator : this.configurators) {
                configurator.configure((JavalinConfig)javalinConfig);
            }
        });
        for (JavalinMiddleware middleware : this.middlewares) {
            middleware.configure(app);
        }
        return app;
    }

    private static SslContextFactory.Server getSslContextFactory(WebserverConfig config) {
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(config.getKeystoreFile());
        sslContextFactory.setKeyStorePassword(config.getKeystorePassword());
        return sslContextFactory;
    }

    private static interface JavalinConfigurator {
        public void configure(JavalinConfig var1);
    }

    private static interface JavalinMiddleware {
        public void configure(Javalin var1);
    }
}

