/*
 * Decompiled with CFR 0.152.
 */
package de.toxicfox.toxicutils.http.server.hadler;

import de.glowman554.config.Savable;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import net.shadew.json.Json;
import net.shadew.json.JsonNode;

public abstract class BaseHandler<U, R>
implements Handler {
    protected Json json = Json.json();
    private final Authentication<U, R> authentication;

    public BaseHandler(Authentication<U, R> authentication) {
        this.authentication = authentication;
    }

    public void json(Context context, JsonNode object) {
        context.contentType("application/json");
        context.result(this.json.serialize(object));
    }

    public void json(Context context, Savable object) {
        this.json(context, object.toJSON());
    }

    public U authenticated(Context context, R role, boolean required) {
        String token = context.cookie("Authentication");
        if (token == null) {
            if (required) {
                throw new RuntimeException("Missing authentication token");
            }
            return null;
        }
        return this.authentication.authenticate(token, role, required);
    }

    public static interface Authentication<T, R> {
        public T authenticate(String var1, R var2, boolean var3);
    }
}

